;http://forums.purebasic.com/english/viewtopic.php?t=15762&start=0&sid=6061d6ba4bd21baba4d3371ac0a40533

;String math expression evaluator, utopiomania 20050627
;PureBasic 3.93

Declare.f Eval(STR.s)
Declare.f Level1()
Declare.f Level2()
Declare.f Level3()
Declare.f Level4()
Declare.f Level5()
Declare.f Level6()
Declare.f Level7()
Declare.f Level8()
Declare.f Level9()
Declare.f Primitive()
Declare.f Calc(Op.s,Num1.f,Num2.f)
Declare.f Unary(Op.s,Num.f)
Declare.f Rewind()
Declare.f LetVar(Var.s,Num.f)
Declare.f GetVar()
Declare.f ClearVars()
Declare GetToken()
Declare IsFunc(STR.s)
Declare IsCommand(STR.s)
Declare IsMinus(STR.s)
Declare IsParenth(STR.s)
Declare IsDelim(STR.s)
Declare NotDelim(STR.s)
Declare IsAlpha(STR.s)
Declare IsDigit(STR.s)
Declare IsSpace(STR.s)
Declare NotValidOp(Op.s)
Declare IsErr(STR.s)

;Holds the expression to be evaluated:
Global Expr.s
;Points to the next token in expression:
Global Progr.l
;Holds the token:
Global Token.s
;Token type:
Global Ttype.l

#MAXVARS=1000
Global Dim VarNames.s(#MAXVARS)
Global Dim Vars.f(#MAXVARS)

#MAXFNC=15
Global Dim Fnc.s(#MAXFNC)
Fnc(0)="ACOS":Fnc(1)="ASIN":Fnc(2)="ATAN":Fnc(3)="ABS"
Fnc(4)="COS":Fnc(5)="INT":Fnc(6)="LOG":Fnc(7)="LOG10"
Fnc(8)="SIN":Fnc(9)="SQR":Fnc(10)="TAN":Fnc(11)="RANDOM"

#MAXCMD=1
Global Dim Cmd.s(#MAXCMD)
Cmd(0)="CLEAR"

;Token types:
#DELIM=1
#VARIABLE=2
#NUMBER=3
#FUNCTION=4
#COMMAND=5

Global Error.s
Global ERR_SYNTAX.s,ERR_PARENTH.s,ERR_NOEXPR.s,ERR_DIVZERO.s
ERR_SYNTAX="SYNTAX ERROR"
ERR_PARENTH="UNBALANCED PARENTHESES"
ERR_NOEXPR="NO EXPRESSION"
ERR_DIVZERO="DIVISION BY ZERO"

Procedure.f Eval(STR.s)
;Entry point into parser
  Progr=1
  Error=""
  Expr=UCase(STR)
  GetToken()
  If Token=""
    Error=ERR_NOEXPR
  EndIf
  IsErr(Expr)
  If Len(Error)
    ProcedureReturn #False
  EndIf
  ProcedureReturn Level1()
EndProcedure

Procedure.f Level1()
;Assignment statement/command
  Typ.l
  Tok.s
  If Ttype=#VARIABLE
    ;Save old token
    Tok=Token
    Typ=Ttype
    GetToken()
    If Token="="
      ;Assignment
      GetToken()
      ProcedureReturn LetVar(Tok,Level2())
    Else
      ;Restore
      Rewind()
      Token=Tok
      Ttype=Typ
    EndIf
  ElseIf Ttype=#COMMAND
    If Token="CLEAR"
      ;Restore
      Rewind()
      Token=Tok
      Ttype=Typ
      ClearVars()
      ProcedureReturn 0
    EndIf
  EndIf
  ProcedureReturn Level2()
EndProcedure

Procedure.f Level2()
;Logical And/Or
  Result.f=Level3()
  Op.s=Token
  While (Op="&")Or(Op="|")
    GetToken()
    Result=Calc(Op,Result,Level3())
    Op=Token
  Wend
  ProcedureReturn Result
EndProcedure

Procedure.f Level3()
;Conditional operators
  Result.f=Level4()
  Op.s=Token
  While (Op="<")Or(Op=">")Or(Op="<>")Or(Op="<=")Or(Op=">=")Or(Op="==")
    GetToken()
    Result=Calc(Op,Result,Level4())
    Op=Token
  Wend
  ProcedureReturn Result
EndProcedure

Procedure.f Level4()
;Add or subtract two terms
  Result.f=Level5()
  Op.s=Token
  While (Op="+")Or(Op="-")
    GetToken()
    Result=Calc(Op,Result,Level5())
    Op=Token
  Wend
  ProcedureReturn Result
EndProcedure

Procedure.f Level5()
;Multiply, divide
  Result.f=Level6()
  Op.s=Token
  While (Op="*")Or(Op="/")
    GetToken()
    Result=Calc(Op,Result,Level6())
    Op=Token
  Wend
  ProcedureReturn Result
EndProcedure

Procedure.f Level6()
;Exponent
  Result.f=Level7()
  If Token="^"
    GetToken()
    Result=Calc("^",Result,Level7())
  EndIf
  ProcedureReturn Result
EndProcedure

Procedure.f Level7()
;Unary plus or minus
  Op.s=""
  If (Ttype=#DELIM)And((Token="+")Or(Token="-"))
    Op=Token
    GetToken()
  EndIf
  Result.f=Level8()
  If Op<>""
    Result=Unary(Op,Result)
  EndIf
  ProcedureReturn Result
EndProcedure

Procedure.f Level8()
;Functions
  Op.s=""
  If Ttype=#FUNCTION
    Op=Token
    GetToken()
  EndIf
  Result.f=Level9()
  If Len(Op)
    Result=Calc(Op,Result,0)
  EndIf
  ProcedureReturn Result
EndProcedure

Procedure.f Level9()
;Parenthesized expression
  Result.f
  If (Ttype=#DELIM)And(Token="(")
    GetToken()
    Result=Level1()
    GetToken()
  Else
    Result=Primitive()
  EndIf
  ProcedureReturn Result
EndProcedure

Procedure.f Primitive()
;Find value of number or variable
  Result.f
  Select Ttype
    Case #VARIABLE
      Result=GetVar()
      GetToken()
    Case #NUMBER
      Result=ValF(Token)
      GetToken()
    Default
      Error=ERR_SYNTAX
  EndSelect
  ProcedureReturn Result
EndProcedure

Procedure.f Calc(Op.s,Num1.f,Num2.f)
  Result.f
  Select Op
    Case "&"
      Result=Num1 And Num2
    Case "|"
      Result=Num1 Or Num2
    Case "<"
      If Num1<Num2
        Result=1
      EndIf
    Case ">"
      If Num1>Num2
        Result=1
      EndIf
    Case "<>"
      If Num1<>Num2
        Result=1
      EndIf
    Case "<="
      If Num1<=Num2
        Result=1
      EndIf
    Case ">="
      If Num1>=Num2
        Result=1
      EndIf
    Case "=="
      If Num1=Num2
        Result=1
      EndIf
    Case "-"
      Result=Num1-Num2
    Case "+"
      Result=Num1+Num2
    Case "*"
      Result=Num1*Num2
    Case "/"
      If Num2<>0
        Result=Num1/Num2
      Else
        Error=ERR_DIVZERO
        Result=0
      EndIf
    Case "^"
      Result=Pow(Num1,Num2)
    Case "ACOS"
      Result=ACos(Num1)
    Case "ASIN"
      Result=ASin(Num1)
    Case "ATAN"
      Result=ATan(Num1)
    Case "ABS"
      Result=Abs(Num1)
    Case "COS"
      Result=Cos(Num1)
    Case "INT"
      Result=Int(Num1)
    Case "LOG"
      Result=Log(Num1)
    Case "LOG10"
      Result=Log10(Num1)
    Case "SIN"
      Result=Sin(Num1)
    Case "SQR"
      Result=Sqr(Num1)
    Case "TAN"
      Result=Tan(Num1)
    Case "RANDOM"
      result=Random(Num1)
  EndSelect
  ProcedureReturn Result
EndProcedure

Procedure.f Unary(Op.s,Num.f)
;Unary minus
  If Op="-"
    ProcedureReturn -Num
  EndIf
  ProcedureReturn Num
EndProcedure

Procedure.f Rewind()
;Back up to the previous token
  Progr=Progr-Len(Token)
EndProcedure

Procedure.f LetVar(Var.s,Num.f);Assign a value to a variable
  I=0
  While Len(VarNames(I))
    If Var=VarNames(I)
      Vars(I)=Num
      ProcedureReturn Num
    EndIf
    I+1
  Wend
  VarNames(I)=Var
  Vars(I)=Num
  ProcedureReturn Num
EndProcedure

Procedure.f GetVar()

;Find value of a variable
  I=0
  While Len(VarNames(I))
    If Token=VarNames(I)
      ProcedureReturn Vars(I)
    EndIf
    I+1
  Wend
  LetVar(Token,0)
  ProcedureReturn GetVar()
EndProcedure

Procedure.f ClearVars();Clears variable names and values:
  For I=0 To #MAXVARS-1
    Vars(I)=0
    VarNames(I)=""
  Next
EndProcedure

Procedure GetToken()
;Get the next token/token type in expression
  Ttype=0
  Token=""
  If Progr>Len(Expr)
    ProcedureReturn
  EndIf
  While IsSpace(Mid(Expr,Progr,1))
    Progr+1
  Wend
  Select #True
    Case IsMinus(Mid(Expr,Progr,1))
      Ttype=#DELIM
      Token=Mid(Expr,Progr,1)
      Progr+1
    Case IsParenth(Mid(Expr,Progr,1))
      Ttype=#DELIM
      Token=Mid(Expr,Progr,1)
      Progr+1
    Case IsDelim(Mid(Expr,Progr,1))
      Ttype=#DELIM
      While IsDelim(Mid(Expr,Progr,1))
        Token+Mid(Expr,Progr,1)
        Progr+1
      Wend
      If NotValidOp(Token)
        Error=ERR_SYNTAX
      EndIf
    Case IsAlpha(Mid(Expr,Progr,1))
      While NotDelim(Mid(Expr,Progr,1))
        Token+Mid(Expr,Progr,1)
        Progr+1
      Wend
      If IsFunc(Token)
        Ttype=#FUNCTION
      Else
        If IsCommand(Token)
          Ttype=#COMMAND
        Else
          Ttype=#VARIABLE
        EndIf
      EndIf
    Case IsDigit(Mid(Expr,Progr,1))
      Ttype=#NUMBER   
      While NotDelim(Mid(Expr,Progr,1))
        Token+Mid(Expr,Progr,1)
        Progr+1
      Wend
  EndSelect
EndProcedure

Procedure IsFunc(STR.s)

  For I=0 To #MAXFNC-1
    If STR=Fnc(I)
      ProcedureReturn #True
    EndIf
  Next
  ProcedureReturn #False
EndProcedure

Procedure IsCommand(STR.s)

  For I=0 To #MAXCMD-1
    If STR=Cmd(I)
      ProcedureReturn #True
    EndIf
  Next
  ProcedureReturn #False
EndProcedure

Procedure IsMinus(STR.s)
  If FindString("-",STR,1)
    ProcedureReturn #True
  EndIf
  ProcedureReturn #False
EndProcedure

Procedure IsParenth(STR.s)
  If FindString("()",STR,1)
    ProcedureReturn #True
  EndIf
  ProcedureReturn #False
EndProcedure

Procedure IsDelim(STR.s)
  If (FindString("&|<>+/*^=",STR,1)>0)And(STR<>"")
    ProcedureReturn #True
  EndIf
  ProcedureReturn #False
EndProcedure

Procedure NotDelim(STR.s)
  If (FindString("&|<>+-/*^=()"+Chr(9)+Chr(32),STR,1)>0)Or(STR="")
    ProcedureReturn #False
  EndIf
  ProcedureReturn #True
EndProcedure

Procedure IsAlpha(STR.s)
  If FindString("ABCDEFGHIJKLMNOPQRSTUVWXYZ",STR,1)
    ProcedureReturn #True
  EndIf
  ProcedureReturn #False
EndProcedure

Procedure IsDigit(STR.s)
  If FindString(".0123456789",STR,1)
    ProcedureReturn #True
  EndIf
  ProcedureReturn #False
EndProcedure

Procedure IsSpace(STR.s)
  If ((STR=" ")Or(STR=Chr(9)))And(STR<>"")
    ProcedureReturn #True
  EndIf
  ProcedureReturn #False
EndProcedure

Procedure NotValidOp(Op.s)
  If Len(Op)=1
    ProcedureReturn #False
  EndIf
  Select Token
    Case "<>"
      ProcedureReturn #False
    Case "<="
      ProcedureReturn #False
    Case ">="
      ProcedureReturn #False
    Case "=="
      ProcedureReturn #False
  EndSelect
  ProcedureReturn #True
EndProcedure

Procedure IsErr(STR.s)
;Check For some errors
  Str1.s
  Str2.s
  Err=0
  STR=UCase(STR)
  ;Check for unbalanced parentheses
  For I=1 To Len(STR)
    If Mid(STR,I,1)="("
      Err+1
    EndIf
    If Mid(STR,I,1)=")"
      Err-1
    EndIf
  Next
  If Err
    Error=ERR_PARENTH
    ProcedureReturn #True
  EndIf
  ;Check for Illegal characters
  Str1=" ABCDEFGHIJKLMNOPQRSTUVWXYZ"
  Str2="0123456789.&|<>+-/%*^=()"+Chr(9)
  For I=1 To Len(STR)
    If FindString(Str1+Str2,Mid(STR,I,1),1)=0
      Err+1
    EndIf
  Next
  If Err
    ProcedureReturn #True
  EndIf
  ProcedureReturn #False
EndProcedure



Procedure.f evalf1(chaine.s , i1.s, v1.f)
ProcedureReturn eval(ReplaceString(chaine,i1,StrF(v1),1))
EndProcedure



; IDE Options = PureBasic v4.02 (Windows - x86)
; CursorPosition = 286
; FirstLine = 283
; Folding = ------